package gov.va.genisis2.bs.converter;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.bs.data.model.Label;
import gov.va.genisis2.ts.common.dto.LabelDTO;

/**
 * Used to convert Label Object to Label DTO's and vice versa
 * @author PII
 */
@Component
public class LabelConverter implements Converter<Label, LabelDTO> {
	@Override
	public LabelDTO convert(Label label) {
		
		LabelDTO labelDto = new LabelDTO();
		
		labelDto.setLabelId(label.getLabelId());
		labelDto.setBookmarkId(label.getBookmarkId());
		labelDto.setName(label.getName());
		labelDto.setUsername(label.getUsername());
		
		return labelDto;
	}
	
	public List<LabelDTO> convert(List<Label> list){
		return list
				.stream()
				.map(l -> convert(l))
				.collect(Collectors.toList());
	}
	
	public Label convert(LabelDTO labelDto) {
		Label label = new Label();
		
		label.setLabelId(labelDto.getLabelId());
		label.setBookmarkId(labelDto.getBookmarkId());
		label.setName(labelDto.getName());
		label.setUsername(labelDto.getUsername());
		
		return label;
	}
}
